package gov.va.vinci.dart.rule;

import gov.va.vinci.dart.common.ValidationHelper;
import gov.va.vinci.dart.common.exception.CheckedException;

import java.util.HashMap;

public class DocumentRuleEvaluatorFactory {

	private static final HashMap<String,DocumentRuleEvaluator> evaluatorHash = new HashMap<String,DocumentRuleEvaluator>();
	
	public static DocumentRuleEvaluator getEvaluator(final String name) throws CheckedException {

		ValidationHelper.required("Data Source Document Rule Evaluator", name);
		
		if (evaluatorHash.get(name) != null) {
			return evaluatorHash.get(name);
		}

		String className = name;
//		if (name.endsWith(".class") == false) {
//			className += ".class";
//		}
	
		try {
			Class<?> clz = Class.forName(className);
			if (DocumentRuleEvaluator.class.isAssignableFrom(clz) == false) {
				throw new CheckedException("Data Source evaluator class is not of appropriate type hierarchy.");
			}
			
			DocumentRuleEvaluator ev = (DocumentRuleEvaluator)clz.newInstance();
			evaluatorHash.put(name,  ev);
			return ev;
		}
		catch (ClassNotFoundException e) {
			throw new CheckedException(e);
		} catch (InstantiationException e) {
			throw new CheckedException(e);
		} catch (IllegalAccessException e) {
			throw new CheckedException(e);
		}
	}
}
